<?php
/* --------------------------------------------------------------
	PayPalInstallmentSpecificUpstreamPresentmentThemeContentView.inc.php 2019-06-12
	Gambio GmbH
	http://www.gambio.de
	Copyright (c) 2016 Gambio GmbH
	Released under the GNU General Public License (Version 2)
	[http://www.gnu.org/licenses/gpl-2.0.html]
	--------------------------------------------------------------
*/

class PayPalInstallmentSpecificUpstreamPresentmentThemeContentView extends ThemeContentView
{
    protected $lender;
    protected $cashPurchasePrice;
    protected $numberOfInstallments;
    protected $borrowingRate;
    protected $annualPercentageRate;
    protected $installmentAmount;
    protected $totalAmount;
    protected $currency;
    protected $representativeFinancingCode;
    
    protected $qualifyingOptions;
    protected $nonQualifyingOptions;
    
    protected $requiredData = [];
    
    
    public function __construct()
    {
        parent::__construct();
        
        $this->set_content_template('paypal_installment_specific.html');
        $this->set_flat_assigns(true);
        $this->set_caching_enabled(false);
        $this->requiredData = [
            'lender',
            'cashPurchasePrice',
            'currency',
            'numberOfInstallments',
            'borrowingRate',
            'annualPercentageRate',
            'installmentAmount',
            'totalAmount',
            'qualifyingOptions',
            'nonQualifyingOptions',
            'representativeFinancingCode'
        ];
    }
    
    
    public function __set($name, $value)
    {
        if (property_exists($this, $name)) {
            switch ($name) {
                case 'cashPurchasePrice':
                case 'installmentAmount':
                case 'totalAmount':
                    $value = sprintf('%s&nbsp;%s', number_format($value, 2, ',', ''), $this->currency);
                    break;
                case 'borrowingRate':
                case 'annualPercentageRate':
                    $value = number_format($value, 2, ',', '');
                    break;
                default:
            }
            $this->{$name} = $value;
        }
    }
    
    
    public function prepare_data()
    {
        foreach ($this->requiredData as $propertyName) {
            if ($this->{$propertyName} === null) {
                throw new Exception('Required data missing: ' . $propertyName);
            } else {
                $this->set_content_data($propertyName, $this->{$propertyName});
            }
        }
        
        $installmentOptionsThemeContentView = MainFactory::create('ThemeContentView');
        $installmentOptionsThemeContentView->set_content_template('paypal_installment_options.html');
        $installmentOptionsThemeContentView->set_flat_assigns(true);
        $installmentOptionsThemeContentView->set_caching_enabled(false);
        $installmentOptionsThemeContentView->set_content_data('lender', $this->lender);
        $installmentOptionsThemeContentView->set_content_data('cashPurchasePrice', $this->cashPurchasePrice);
        $installmentOptionsThemeContentView->set_content_data('currency', $this->currency);
        $installmentOptionsThemeContentView->set_content_data('qualifyingOptions', $this->qualifyingOptions);
        // $installmentOptionsThemeContentView->set_content_data('nonQualifyingOptions',        $this->nonQualifyingOptions);
        $installmentOptionsThemeContentView->set_content_data('representativeFinancingCode',
                                                              $this->representativeFinancingCode);
        $this->set_content_data('installmentOptions', $installmentOptionsThemeContentView->get_html());
    }
    
}
